import java.awt.geom.*;  

import javax.imageio.ImageIO;
import javax.swing.*;

import java.io.File;
import java.io.IOException;

import java.awt.*;
import java.awt.geom.Point2D;


/* Length of the Day Application - representation.java file
* 
* Developed by Cristina Vinas Vinuales - Institute for Biocomputation and Physics of Complex Systems (BIFI) - Zaragoza
* for Science on Stage on January 2012
* 
*/

class representation extends JPanel {
	
		/***********************************************************************************************************************/
	    /*This class store the data for each calculation*/
		class sunPath{
			public String name;
			public double orto;
			public double ocaso;
			public Color colour;
			public Point2D.Double points[];
			public int nPoints;
						
			public sunPath(int day, int month, int year, double lon, double lat, double orto, double ocaso, Color value) {
				this.name = Integer.toString(day) + "/" + Integer.toString(month) + "/" + Integer.toString(year) + " at " + Double.toString(lon) + "_" + Double.toString(lat).substring(0, 4);
				this.orto = orto;
				this.ocaso = ocaso;
				this.colour = value;
				points = new Point2D.Double[100];
				nPoints = 0;
			}
			
			public void addP(Point2D p){
				points[nPoints] = new Point2D.Double(p.getX(),p.getY());
				nPoints++;				
			}			
		}
		/***********************************************************************************************************************/
		public representation() {
			numLines = 0;
			allLines = new sunPath[10];
			
		}
		
		/***********************************************************************************************************************/
		
		public void recordRepresentation(int day, int month, int year, double lon, double lat, double orto, double ocaso) {
			
			if (numLines < MAX_PAINTED_LINES) { 
			 allLines[numLines] = new sunPath(day,month,year,lon,lat, orto, ocaso, palette[numLines % 11]);
			 numLines = numLines + 1;
			}
		}
		/***********************************************************************************************************************/
		
		public void deleteRepresentations() {
			allLines = null;
			numLines = 0;
			allLines = new sunPath[10];
		}
		/***********************************************************************************************************************/
		
		public void addPointLastRecord(Point2D p){
			if (numLines < MAX_PAINTED_LINES) { 
				allLines[numLines - 1].addP(p);		
			}
		}
		
		/***********************************************************************************************************************/
		
		public void paintComponent(Graphics g) 
        { 
             super.paintComponent(g); 
             
             Graphics2D g2 = (Graphics2D) g;
                          
             //Background
             Image img = null;
             try {
				img = ImageIO.read(new File("images/background.png")); //TODO: adjust width and height of image file
			 } catch (IOException e) {
				e.printStackTrace();
			 }
             if (img != null)
            	 g2.drawImage(img, 0, 0, null);
             
             g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER, 10.0f, dash1, 0.0f));
             g2.setColor(Color.black);
             g2.setBackground(Color.white);
             
             //Heigth line 
             g2.setColor(Color.lightGray);
             Line2D.Double height = new Line2D.Double(10, 20, 10, 350);
             g2.draw(height);
             g2.drawString("heigth on the horizon (degrees)",15,20);
             g2.drawString("90",15,70);
             g2.drawString("75",15,120);
             g2.drawString("60",15,170);
             g2.drawString("45",15,220);
             g2.drawString("30",15,270);
                          
             //Horizon line
             g2.setColor(Color.black);
             g2.setStroke(new BasicStroke(2));
             Line2D.Double horizon = new Line2D.Double(10, 340, 780, 340);
             g2.draw(horizon);
             
             //Division per Hours             
             g2.setStroke(new BasicStroke(1));
             int x = 15;
             int h = 0;
             for (int i=0; i < 24; i++) {
            	 Line2D.Double mark = new Line2D.Double(x, 338, x, 342);
                 g2.draw(mark);            	 
                 g2.drawString(Integer.toString(h),x,355);
                 x += 32;
                 h +=1;
             }
             g2.setColor(Color.lightGray);
             g2.drawString("time (h)",740,335);
                         
     		 
     		 //draw lines     		 
             for (int i=0; i < numLines; i++) {
     			g2.setColor(allLines[i].colour);
     			for (int k=0; k < allLines[i].nPoints - 1; k++) {
     				Line2D.Double line = new Line2D.Double(allLines[i].points[k].getX(), allLines[i].points[k].getY(), allLines[i].points[k+1].getX(), allLines[i].points[k+1].getY());
     				g2.draw(line);
     			}
     		 }
     		 
     		 //LEYENDA
     		 g2.setColor(Color.black);
     		 Rectangle2D legend = new Rectangle2D.Double(590, 10, 180, numLines*16);
     		 g2.setPaint(new Color(240,240,240));
     		 g2.fill(legend);
     		 for (int i=0; i < numLines; i++) {
     			 g2.setColor(allLines[i].colour);
     			 Line2D.Double mark = new Line2D.Double(605, 25 + i*15, 635, 25 + i*15);
                 g2.draw(mark);         
                 g2.setColor(Color.black);
                 g2.drawString(allLines[i].name, 645 ,25 + i*15);                 
            }
        }
		
		/***********************************************************************************************************************/
        
		final static float dash1[] = { 10.0f };
		Color palette[] = { Color.blue, Color.green, Color.red, Color.cyan, Color.magenta, Color.black, Color.orange,  Color.yellow, Color.gray, Color.darkGray, Color.lightGray};
		
		public sunPath allLines[];
		public int numLines;
		static int MAX_PAINTED_LINES = 10;		
		
        
}